/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.trace.hook;

import java.util.ArrayList;
import org.apache.rocketmq.client.trace.TraceBean;
import org.apache.rocketmq.client.trace.TraceContext;
import org.apache.rocketmq.client.trace.TraceDispatcher;
import org.apache.rocketmq.client.trace.TraceType;
import org.apache.rocketmq.common.producer.RecallMessageHandle;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.protocol.NamespaceUtil;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.header.RecallMessageRequestHeader;

public class DefaultRecallMessageTraceHook
implements RPCHook {
    private static final String RECALL_TRACE_ENABLE_KEY = "com.rocketmq.recall.default.trace.enable";
    private boolean enableDefaultTrace = Boolean.parseBoolean(System.getProperty("com.rocketmq.recall.default.trace.enable", "false"));
    private TraceDispatcher traceDispatcher;

    public DefaultRecallMessageTraceHook(TraceDispatcher traceDispatcher) {
        this.traceDispatcher = traceDispatcher;
    }

    public void doBeforeRequest(String remoteAddr, RemotingCommand request) {
    }

    public void doAfterResponse(String remoteAddr, RemotingCommand request, RemotingCommand response) {
        if (request.getCode() != 370 || !this.enableDefaultTrace || null == response.getExtFields() || null == response.getExtFields().get("MSG_REGION") || null == this.traceDispatcher) {
            return;
        }
        try {
            String regionId = (String)response.getExtFields().get("MSG_REGION");
            RecallMessageRequestHeader requestHeader = (RecallMessageRequestHeader)request.decodeCommandCustomHeader(RecallMessageRequestHeader.class);
            String topic = NamespaceUtil.withoutNamespace((String)requestHeader.getTopic());
            String group = NamespaceUtil.withoutNamespace((String)requestHeader.getProducerGroup());
            String recallHandle = requestHeader.getRecallHandle();
            RecallMessageHandle.HandleV1 handleV1 = (RecallMessageHandle.HandleV1)RecallMessageHandle.decodeHandle((String)recallHandle);
            TraceBean traceBean = new TraceBean();
            traceBean.setTopic(topic);
            traceBean.setMsgId(handleV1.getMessageId());
            TraceContext traceContext = new TraceContext();
            traceContext.setRegionId(regionId);
            traceContext.setTraceBeans(new ArrayList<TraceBean>(1));
            traceContext.setTraceType(TraceType.Recall);
            traceContext.setGroupName(group);
            traceContext.getTraceBeans().add(traceBean);
            traceContext.setSuccess(0 == response.getCode());
            this.traceDispatcher.append(traceContext);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

