/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.style.se1;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.sis.filter.Expression;
import org.apache.sis.style.se1.ContrastMethod;
import org.apache.sis.style.se1.StyleElement;
import org.apache.sis.style.se1.StyleFactory;

@XmlType(name="ContrastEnhancementType", propOrder={"gammaValue"})
@XmlRootElement(name="ContrastEnhancement")
public class ContrastEnhancement<R>
extends StyleElement<R> {
    protected ContrastMethod method;
    @XmlElement(name="GammaValue")
    protected Expression<R, ? extends Number> gammaValue;

    private ContrastEnhancement() {
    }

    public ContrastEnhancement(StyleFactory<R> factory) {
        super(factory);
    }

    public ContrastEnhancement(ContrastEnhancement<R> source) {
        super(source);
        this.method = source.method;
        this.gammaValue = source.gammaValue;
    }

    public ContrastMethod getMethod() {
        ContrastMethod value = this.method;
        if (value != null) {
            return value;
        }
        return this.gammaValue != null ? ContrastMethod.GAMMA : ContrastMethod.NONE;
    }

    public void setMethod(ContrastMethod value) {
        this.method = value;
        if (value != ContrastMethod.GAMMA) {
            this.gammaValue = null;
        }
    }

    public Expression<R, ? extends Number> getGammaValue() {
        return this.defaultToOne(this.gammaValue);
    }

    public void setGammaValue(Expression<R, ? extends Number> value) {
        this.gammaValue = value;
        if (value != null) {
            this.method = null;
        }
    }

    @Override
    final Object[] properties() {
        return new Object[]{this.method, this.gammaValue};
    }

    @Override
    public ContrastEnhancement<R> clone() {
        return (ContrastEnhancement)super.clone();
    }
}

