/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.ByteArrayInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.derby.iapi.services.io.AccessibleByteArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatIdInputStream;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.io.Formatable;

class DebugByteTeeOutputStream
extends FilterOutputStream {
    private AccessibleByteArrayOutputStream tee = new AccessibleByteArrayOutputStream(256);

    DebugByteTeeOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public void write(int n) throws IOException {
        this.out.write(n);
        this.tee.write(n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.tee.write(byArray, n, n2);
    }

    void checkObject(Formatable formatable) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.tee.getInternalByteArray(), 0, this.tee.size());
        FormatIdInputStream formatIdInputStream = new FormatIdInputStream(byteArrayInputStream);
        Formatable formatable2 = null;
        try {
            formatable2 = (Formatable)formatIdInputStream.readObject();
            if (formatable2.equals(formatable)) {
                return;
            }
            if (formatable2.hashCode() == System.identityHashCode(formatable2) && formatable.hashCode() == System.identityHashCode(formatable)) {
                return;
            }
        }
        catch (Throwable throwable) {
            String string = "FormatableError:read error    : " + throwable.toString() + "\nFormatableError:class written : " + formatable.getClass();
            string = string + (String)(formatable2 == null ? "FormatableError:read back as null" : "FormatableError:class read    : " + formatable2.getClass());
            string = string + "FormatableError:write id      : " + FormatIdUtil.formatIdToString(formatable.getTypeFormatId());
            if (formatable2 != null) {
                string = string + "FormatableError:read id       : " + FormatIdUtil.formatIdToString(formatable2.getTypeFormatId());
            }
            System.out.println(string);
            throwable.printStackTrace(System.out);
        }
    }
}

