/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.storm.scheduler.utils.IConfigLoader;
import org.apache.storm.utils.ServerConfigUtils;
import org.apache.storm.utils.Time;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class ArtifactoryConfigLoader
implements IConfigLoader {
    protected static final String LOCAL_ARTIFACT_DIR = "scheduler_artifacts";
    static final String cacheFilename = "latest.yaml";
    private static final String DEFAULT_ARTIFACTORY_BASE_DIRECTORY = "/artifactory";
    private static final int DEFAULT_POLLTIME_SECS = 600;
    private static final int DEFAULT_TIMEOUT_SECS = 10;
    private static final String ARTIFACTORY_SCHEME_PREFIX = "artifactory+";
    private static final Logger LOG = LoggerFactory.getLogger(ArtifactoryConfigLoader.class);
    private Map<String, Object> conf;
    private int artifactoryPollTimeSecs = 600;
    private boolean cacheInitialized = false;
    private String localCacheDir;
    private String baseDirectory = "/artifactory";
    private int lastReturnedTime = 0;
    private int timeoutSeconds = 10;
    private Map<String, Object> lastReturnedValue;
    private URI targetUri = null;
    private JSONParser jsonParser;
    private String scheme;

    public ArtifactoryConfigLoader(Map<String, Object> conf) {
        String uriString;
        String thisBase;
        Integer thisPollTime;
        this.conf = conf;
        Integer thisTimeout = (Integer)conf.get("scheduler.config.loader.timeout.secs");
        if (thisTimeout != null) {
            this.timeoutSeconds = thisTimeout;
        }
        if ((thisPollTime = (Integer)conf.get("scheduler.config.loader.polltime.secs")) != null) {
            this.artifactoryPollTimeSecs = thisPollTime;
        }
        if ((thisBase = (String)conf.get("scheduler.config.loader.artifactory.base.directory")) != null) {
            this.baseDirectory = thisBase;
        }
        if ((uriString = (String)conf.get("scheduler.config.loader.uri")) == null) {
            LOG.error("No URI defined in {} configuration.", (Object)"scheduler.config.loader.uri");
        } else {
            try {
                this.targetUri = new URI(uriString);
                this.scheme = this.targetUri.getScheme().substring(ARTIFACTORY_SCHEME_PREFIX.length());
            }
            catch (URISyntaxException e) {
                LOG.error("Failed to parse uri={}", (Object)uriString);
            }
        }
        this.jsonParser = new JSONParser();
    }

    public Map<String, Object> load(String configKey) {
        if (this.targetUri == null) {
            return null;
        }
        int currentTimeSecs = Time.currentTimeSecs();
        if (this.lastReturnedValue != null && currentTimeSecs - this.lastReturnedTime < this.artifactoryPollTimeSecs) {
            LOG.debug("currentTimeSecs: {}; lastReturnedTime {}; artifactoryPollTimeSecs: {}. Returning our last map.", new Object[]{currentTimeSecs, this.lastReturnedTime, this.artifactoryPollTimeSecs});
            return (Map)this.lastReturnedValue.get(configKey);
        }
        try {
            Map<String, Object> raw = this.loadFromUri(this.targetUri);
            if (raw != null) {
                return (Map)raw.get(configKey);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to load from uri {}", (Object)this.targetUri);
        }
        return null;
    }

    protected String doGet(String api, String artifact, String host, Integer port) {
        String returnValue;
        URIBuilder builder = new URIBuilder().setScheme(this.scheme).setHost(host).setPort(port.intValue());
        Object path = null;
        path = api != null ? this.baseDirectory + "/" + api + "/" + artifact : this.baseDirectory + "/" + artifact;
        path = ((String)path).replaceAll("/[/]+", "/");
        builder.setPath((String)path);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.timeoutSeconds * 1000).build();
        CloseableHttpClient httpclient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
        try {
            String responseBody;
            LOG.debug("About to issue a GET to {}", (Object)builder);
            HttpGet httpget = new HttpGet(builder.build());
            returnValue = responseBody = (String)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)GetStringResponseHandler.getInstance());
        }
        catch (Exception e) {
            LOG.error("Received exception while connecting to Artifactory", (Throwable)e);
            returnValue = null;
        }
        LOG.debug("Returning {}", returnValue);
        return returnValue;
    }

    private JSONObject getArtifactMetadata(String location, String host, Integer port) {
        JSONObject returnValue;
        String metadataStr = null;
        metadataStr = this.doGet("/api/storage", location, host, port);
        if (metadataStr == null) {
            return null;
        }
        try {
            returnValue = (JSONObject)this.jsonParser.parse(metadataStr);
        }
        catch (ParseException e) {
            LOG.error("Could not parse JSON string {}", (Object)metadataStr, (Object)e);
            return null;
        }
        return returnValue;
    }

    private String loadMostRecentArtifact(String location, String host, Integer port) {
        JSONObject json = this.getArtifactMetadata(location, host, port);
        if (json == null) {
            LOG.error("got null metadata");
            return null;
        }
        String downloadUri = (String)json.get((Object)"downloadUri");
        if (downloadUri != null) {
            String returnValue = this.doGet(null, location, host, port);
            this.saveInArtifactoryCache(returnValue);
            return returnValue;
        }
        JSONArray msg = (JSONArray)json.get((Object)"children");
        if (msg == null || msg.size() == 0) {
            LOG.error("Expected directory children not present");
            return null;
        }
        JSONObject newest = (JSONObject)Collections.max(msg, new DirEntryCompare());
        if (newest == null) {
            LOG.error("Failed to find most recent artifact uri in {}", (Object)location);
            return null;
        }
        String uri = (String)newest.get((Object)"uri");
        if (uri == null) {
            LOG.error("Expected directory uri not present");
            return null;
        }
        String returnValue = this.doGet(null, location + uri, host, port);
        this.saveInArtifactoryCache(returnValue);
        return returnValue;
    }

    private void updateLastReturned(Map ret) {
        this.lastReturnedTime = Time.currentTimeSecs();
        this.lastReturnedValue = ret;
    }

    private Map<String, Object> loadFromFile(File file) {
        Map ret = null;
        try {
            ret = (Map)Utils.readYamlFile((String)file.getCanonicalPath());
        }
        catch (IOException e) {
            LOG.error("Filed to load from file. Exception: {}", (Object)e.getMessage());
        }
        if (ret != null) {
            try {
                LOG.debug("returning a new map from file {}", (Object)file.getCanonicalPath());
            }
            catch (IOException e) {
                LOG.debug("Could not get PATH from file object in debug print. Ignoring");
            }
            return ret;
        }
        return null;
    }

    private Map<String, Object> getLatestFromCache() {
        String localFileName = this.localCacheDir + File.separator + cacheFilename;
        return this.loadFromFile(new File(localFileName));
    }

    private void saveInArtifactoryCache(String yamlData) {
        if (yamlData == null) {
            LOG.warn("Will not save null data into the artifactory cache");
            return;
        }
        String localFileName = this.localCacheDir + File.separator + cacheFilename;
        File cacheFile = new File(localFileName);
        try (FileOutputStream fos = new FileOutputStream(cacheFile);){
            fos.write(yamlData.getBytes());
            fos.flush();
        }
        catch (IOException e) {
            LOG.error("Received exception when writing file {}.  Attempting delete", (Object)localFileName, (Object)e);
            try {
                cacheFile.delete();
            }
            catch (Exception deleteException) {
                LOG.error("Received exception when deleting file {}.", (Object)localFileName, (Object)deleteException);
            }
        }
    }

    private void makeArtifactoryCache(String location) throws IOException {
        String localDirName = ServerConfigUtils.masterLocalDir(this.conf) + File.separator + LOCAL_ARTIFACT_DIR;
        File dir = new File(localDirName);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.localCacheDir = localDirName + File.separator + location.replaceAll(File.separator, "_");
        dir = new File(this.localCacheDir);
        if (!dir.exists()) {
            dir.mkdir();
        }
        this.cacheInitialized = true;
    }

    private Map<String, Object> loadFromUri(URI uri) throws IOException {
        String yamlConfig;
        String host = uri.getHost();
        Integer port = uri.getPort();
        String location = uri.getPath();
        if (location.toLowerCase().startsWith(this.baseDirectory.toLowerCase())) {
            location = location.substring(this.baseDirectory.length());
        }
        if (!this.cacheInitialized) {
            this.makeArtifactoryCache(location);
        }
        if ((yamlConfig = this.loadMostRecentArtifact(location, host, port)) == null) {
            Map<String, Object> ret = this.getLatestFromCache();
            this.updateLastReturned(ret);
            return ret;
        }
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        Map ret = null;
        try {
            ret = (Map)yaml.load(yamlConfig);
        }
        catch (Exception e) {
            LOG.error("Could not parse yaml.");
            return null;
        }
        if (ret != null) {
            LOG.debug("returning a new map from Artifactory");
            this.updateLastReturned(ret);
            return ret;
        }
        return null;
    }

    private static class GetStringResponseHandler
    implements ResponseHandler<String> {
        private static GetStringResponseHandler singleton = null;

        private GetStringResponseHandler() {
        }

        public static GetStringResponseHandler getInstance() {
            if (singleton == null) {
                singleton = new GetStringResponseHandler();
            }
            return singleton;
        }

        public String handleResponse(HttpResponse response) throws IOException {
            String entityString;
            int status = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            String string = entityString = entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
            if (status >= 200 && status < 300) {
                return entityString;
            }
            LOG.error("Got unexpected response code {}; entity: {}", (Object)status, (Object)entityString);
            return null;
        }
    }

    private class DirEntryCompare
    implements Comparator<Object> {
        private DirEntryCompare() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            JSONObject j1 = (JSONObject)o1;
            JSONObject j2 = (JSONObject)o2;
            return ((String)j1.get((Object)"uri")).compareTo((String)j2.get((Object)"uri"));
        }
    }
}

