/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class ConcatStep<S>
extends ScalarMapStep<S, String>
implements TraversalParent {
    private List<Traversal.Admin<S, String>> concatTraversals;
    private List<String> concatStrings;
    private String stringArgsResult;
    private boolean isNullTraverser = true;
    private boolean isNullTraversal = true;
    private boolean isNullString = true;

    public ConcatStep(Traversal.Admin traversal, String ... concatStrings) {
        super(traversal);
        this.concatStrings = null == concatStrings ? null : Collections.unmodifiableList(Arrays.asList(concatStrings));
        this.stringArgsResult = this.processStrings(concatStrings);
    }

    public ConcatStep(Traversal.Admin traversal, Traversal<?, String> concatTraversal, Traversal<?, String> ... otherConcatTraversals) {
        super(traversal);
        List<Traversal.Admin<Object, String>> list = this.concatTraversals = null == concatTraversal ? new ArrayList<Traversal.Admin<S, String>>() : new ArrayList(Collections.singletonList(concatTraversal.asAdmin()));
        if (null != otherConcatTraversals) {
            this.concatTraversals.addAll(Stream.of(otherConcatTraversals).filter(Objects::nonNull).map((? super T ct) -> ct.asAdmin()).collect(Collectors.toList()));
        }
        this.concatTraversals.forEach(this::integrateChild);
    }

    @Override
    protected String map(Traverser.Admin<S> traverser) {
        if (null != traverser.get() && !(traverser.get() instanceof String)) {
            throw new IllegalArgumentException(String.format("String concat() can only take string as argument, encountered %s", traverser.get().getClass()));
        }
        StringBuilder sb = new StringBuilder();
        if (null != traverser.get()) {
            this.isNullTraverser = false;
            sb.append(traverser.get());
        }
        if (null != this.concatTraversals) {
            this.concatTraversals.forEach(ct -> {
                String result = (String)TraversalUtil.apply(traverser, ct);
                if (null != result) {
                    this.isNullTraversal = false;
                    sb.append(result);
                }
            });
        }
        if (!this.isNullString) {
            sb.append(this.stringArgsResult);
        }
        if (this.isNullTraverser && this.isNullTraversal && this.isNullString) {
            return null;
        }
        this.isNullTraverser = true;
        this.isNullTraversal = true;
        return sb.toString();
    }

    private String processStrings(String[] concatStrings) {
        StringBuilder sb = new StringBuilder();
        if (null != concatStrings && concatStrings.length != 0) {
            for (String s : concatStrings) {
                if (null == s) continue;
                this.isNullString = false;
                sb.append(s);
            }
        }
        return this.isNullString ? null : sb.toString();
    }

    public List<String> getConcatStrings() {
        return this.concatStrings;
    }

    public String getStringArgsResult() {
        return this.stringArgsResult;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.OBJECT);
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        if (null != this.concatTraversals) {
            for (Traversal.Admin<S, String> traversal : this.concatTraversals) {
                this.integrateChild(traversal);
            }
        }
    }

    @Override
    public ConcatStep<S> clone() {
        ConcatStep clone = (ConcatStep)super.clone();
        if (null != this.concatTraversals) {
            clone.concatTraversals = new ArrayList<Traversal.Admin<S, String>>();
            for (Traversal.Admin<S, String> concatTraversals : this.concatTraversals) {
                clone.concatTraversals.add(concatTraversals.clone());
            }
        }
        if (null != this.concatStrings) {
            clone.concatStrings = new ArrayList<String>();
            clone.concatStrings.addAll(this.concatStrings);
        }
        return clone;
    }

    public List<Traversal.Admin<S, String>> getLocalChildren() {
        return null == this.concatTraversals ? Collections.emptyList() : this.concatTraversals;
    }

    @Override
    public String toString() {
        if (null != this.concatTraversals) {
            return StringFactory.stepString(this, this.concatTraversals);
        }
        return StringFactory.stepString(this, this.concatStrings);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (null != this.concatTraversals) {
            for (Traversal traversal : this.concatTraversals) {
                result = 31 * result + (null != traversal ? traversal.hashCode() : 0);
            }
        }
        if (null != this.concatStrings) {
            for (String string : this.concatStrings) {
                result = 31 * result + (null != string ? string.hashCode() : 0);
            }
        }
        return result;
    }
}

