/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel.exps;

import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.apache.openjpa.kernel.Extent;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.exps.Abs;
import org.apache.openjpa.kernel.exps.Add;
import org.apache.openjpa.kernel.exps.Aggregate;
import org.apache.openjpa.kernel.exps.AggregateListener;
import org.apache.openjpa.kernel.exps.All;
import org.apache.openjpa.kernel.exps.AndExpression;
import org.apache.openjpa.kernel.exps.Any;
import org.apache.openjpa.kernel.exps.Args;
import org.apache.openjpa.kernel.exps.Arguments;
import org.apache.openjpa.kernel.exps.Avg;
import org.apache.openjpa.kernel.exps.BindKeyVariableExpression;
import org.apache.openjpa.kernel.exps.BindValueVariableExpression;
import org.apache.openjpa.kernel.exps.BindVariableAndExpression;
import org.apache.openjpa.kernel.exps.BindVariableExpression;
import org.apache.openjpa.kernel.exps.BoundVariable;
import org.apache.openjpa.kernel.exps.CandidatePath;
import org.apache.openjpa.kernel.exps.Cast;
import org.apache.openjpa.kernel.exps.Ceiling;
import org.apache.openjpa.kernel.exps.Coalesce;
import org.apache.openjpa.kernel.exps.CollectionParam;
import org.apache.openjpa.kernel.exps.Concat;
import org.apache.openjpa.kernel.exps.ContainsExpression;
import org.apache.openjpa.kernel.exps.ContainsKeyExpression;
import org.apache.openjpa.kernel.exps.ContainsValueExpression;
import org.apache.openjpa.kernel.exps.Count;
import org.apache.openjpa.kernel.exps.CurrentDate;
import org.apache.openjpa.kernel.exps.CurrentTemporal;
import org.apache.openjpa.kernel.exps.DateTimeExtractField;
import org.apache.openjpa.kernel.exps.DateTimeExtractPart;
import org.apache.openjpa.kernel.exps.Distinct;
import org.apache.openjpa.kernel.exps.Divide;
import org.apache.openjpa.kernel.exps.EndsWithExpression;
import org.apache.openjpa.kernel.exps.EqualExpression;
import org.apache.openjpa.kernel.exps.Exp;
import org.apache.openjpa.kernel.exps.Exponential;
import org.apache.openjpa.kernel.exps.Expression;
import org.apache.openjpa.kernel.exps.ExpressionFactory;
import org.apache.openjpa.kernel.exps.Extension;
import org.apache.openjpa.kernel.exps.ExtractDateTimeField;
import org.apache.openjpa.kernel.exps.ExtractDateTimePart;
import org.apache.openjpa.kernel.exps.FilterListener;
import org.apache.openjpa.kernel.exps.Floor;
import org.apache.openjpa.kernel.exps.GeneralCase;
import org.apache.openjpa.kernel.exps.GetMapValue;
import org.apache.openjpa.kernel.exps.GetObjectId;
import org.apache.openjpa.kernel.exps.GreaterThanEqualExpression;
import org.apache.openjpa.kernel.exps.GreaterThanExpression;
import org.apache.openjpa.kernel.exps.Index;
import org.apache.openjpa.kernel.exps.IndexOf;
import org.apache.openjpa.kernel.exps.InstanceofExpression;
import org.apache.openjpa.kernel.exps.IsEmptyExpression;
import org.apache.openjpa.kernel.exps.LessThanEqualExpression;
import org.apache.openjpa.kernel.exps.LessThanExpression;
import org.apache.openjpa.kernel.exps.Lit;
import org.apache.openjpa.kernel.exps.Literal;
import org.apache.openjpa.kernel.exps.MatchesExpression;
import org.apache.openjpa.kernel.exps.Max;
import org.apache.openjpa.kernel.exps.Min;
import org.apache.openjpa.kernel.exps.Mod;
import org.apache.openjpa.kernel.exps.Multiply;
import org.apache.openjpa.kernel.exps.NaturalLogarithm;
import org.apache.openjpa.kernel.exps.NotEqualExpression;
import org.apache.openjpa.kernel.exps.NotExpression;
import org.apache.openjpa.kernel.exps.Null;
import org.apache.openjpa.kernel.exps.NullIf;
import org.apache.openjpa.kernel.exps.OrExpression;
import org.apache.openjpa.kernel.exps.Param;
import org.apache.openjpa.kernel.exps.Parameter;
import org.apache.openjpa.kernel.exps.Path;
import org.apache.openjpa.kernel.exps.Power;
import org.apache.openjpa.kernel.exps.QueryExpressions;
import org.apache.openjpa.kernel.exps.Round;
import org.apache.openjpa.kernel.exps.Sign;
import org.apache.openjpa.kernel.exps.SimpleCase;
import org.apache.openjpa.kernel.exps.Size;
import org.apache.openjpa.kernel.exps.Sqrt;
import org.apache.openjpa.kernel.exps.StartsWithExpression;
import org.apache.openjpa.kernel.exps.StringLength;
import org.apache.openjpa.kernel.exps.SubQ;
import org.apache.openjpa.kernel.exps.Subquery;
import org.apache.openjpa.kernel.exps.Substring;
import org.apache.openjpa.kernel.exps.Subtract;
import org.apache.openjpa.kernel.exps.Sum;
import org.apache.openjpa.kernel.exps.This;
import org.apache.openjpa.kernel.exps.ToLowerCase;
import org.apache.openjpa.kernel.exps.ToUpperCase;
import org.apache.openjpa.kernel.exps.Trim;
import org.apache.openjpa.kernel.exps.Type;
import org.apache.openjpa.kernel.exps.TypeLit;
import org.apache.openjpa.kernel.exps.UnboundVariable;
import org.apache.openjpa.kernel.exps.Val;
import org.apache.openjpa.kernel.exps.ValExpression;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.kernel.exps.ValuePath;
import org.apache.openjpa.kernel.exps.WhenCondition;
import org.apache.openjpa.kernel.exps.WhenScalar;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.UnsupportedException;
import org.apache.openjpa.util.UserException;

public class InMemoryExpressionFactory
implements ExpressionFactory {
    private static final Value NULL = new Null();
    private static final Object UNIQUE = new Object();
    private List<UnboundVariable> _unbounds = null;

    public boolean matches(QueryExpressions exps, ClassMetaData type, boolean subs, Object candidate, StoreContext ctx, Object[] params) {
        if (candidate == null) {
            return false;
        }
        if (!subs && candidate.getClass() != type.getDescribedType()) {
            return false;
        }
        if (subs && !type.getDescribedType().isAssignableFrom(candidate.getClass())) {
            return false;
        }
        return this.matches((Exp)exps.filter, candidate, ctx, params, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean matches(Exp exp, Object candidate, StoreContext ctx, Object[] params, int i) {
        if (this._unbounds == null || i == this._unbounds.size()) {
            return exp.evaluate(candidate, candidate, ctx, params);
        }
        UnboundVariable var = this._unbounds.get(i);
        Iterator<Object> itr = ctx.extentIterator(var.getType(), true, null, false);
        try {
            if (!itr.hasNext()) {
                var.setValue(null);
                boolean bl = this.matches(exp, candidate, ctx, params, i + 1);
                return bl;
            }
            while (itr.hasNext()) {
                var.setValue(itr.next());
                if (!this.matches(exp, candidate, ctx, params, i + 1)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            ImplHelper.close(itr);
        }
    }

    public List group(QueryExpressions exps, List matches, StoreContext ctx, Object[] params) {
        if (matches == null || matches.isEmpty() || exps.grouping.length == 0) {
            return matches;
        }
        matches = this.order(exps, exps.grouping, false, matches, ctx, params);
        Object[] prevs = new Object[exps.grouping.length];
        Arrays.fill(prevs, UNIQUE);
        Object[] curs = new Object[exps.grouping.length];
        ArrayList grouped = new ArrayList();
        ArrayList group = null;
        Iterator iterator = matches.iterator();
        while (iterator.hasNext()) {
            Object match;
            Object pc = match = iterator.next();
            boolean eq = true;
            for (int i = 0; i < exps.grouping.length; ++i) {
                curs[i] = ((Val)exps.grouping[i]).evaluate(pc, pc, ctx, params);
                eq = eq && Objects.equals(prevs[i], curs[i]);
            }
            if (!eq) {
                if (group != null) {
                    grouped.add(group);
                }
                group = new ArrayList();
            }
            group.add(pc);
            System.arraycopy(curs, 0, prevs, 0, curs.length);
        }
        if (group != null) {
            grouped.add(group);
        }
        return grouped;
    }

    public boolean matches(QueryExpressions exps, Collection group, StoreContext ctx, Object[] params) {
        if (group == null || group.isEmpty()) {
            return false;
        }
        if (exps.having == null) {
            return true;
        }
        return this.matches((Exp)exps.having, group, ctx, params, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matches(Exp exp, Collection group, StoreContext ctx, Object[] params, int i) {
        if (this._unbounds == null || i == this._unbounds.size()) {
            return exp.evaluate(group, ctx, params);
        }
        UnboundVariable var = this._unbounds.get(i);
        Extent extent = ctx.getBroker().newExtent(var.getType(), true);
        Iterator itr = extent.iterator();
        try {
            if (!itr.hasNext()) {
                var.setValue(null);
                boolean bl = this.matches(exp, group, ctx, params, i + 1);
                return bl;
            }
            while (itr.hasNext()) {
                var.setValue(itr.next());
                if (!this.matches(exp, group, ctx, params, i + 1)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            ImplHelper.close(itr);
        }
    }

    public List project(QueryExpressions exps, List matches, StoreContext ctx, Object[] params) {
        if (exps.projections.length == 0) {
            return matches;
        }
        if (exps.grouping.length == 0 && exps.isAggregate()) {
            Object[] projection = this.project(matches, exps, true, ctx, params);
            return Arrays.asList(new Object[]{projection});
        }
        ArrayList<Object[]> projected = new ArrayList<Object[]>(matches.size());
        for (Object match : matches) {
            projected.add(this.project(match, exps, exps.grouping.length > 0, ctx, params));
        }
        return projected;
    }

    private Object[] project(Object candidate, QueryExpressions exps, boolean agg, StoreContext ctx, Object[] params) {
        Object[] projection = new Object[exps.projections.length + exps.ordering.length];
        Object result = null;
        for (int i = 0; i < exps.projections.length; ++i) {
            result = agg ? ((Val)exps.projections[i]).evaluate((Collection)candidate, null, ctx, params) : ((Val)exps.projections[i]).evaluate(candidate, candidate, ctx, params);
            projection[i] = result;
        }
        for (int i = 0; i < exps.ordering.length; ++i) {
            boolean repeat = false;
            for (int j = 0; !repeat && j < exps.projections.length; ++j) {
                if (!exps.orderingClauses[i].equals(exps.projectionClauses[j])) continue;
                result = projection[j];
                repeat = true;
            }
            if (!repeat) {
                result = agg ? ((Val)exps.ordering[i]).evaluate((Collection)candidate, null, ctx, params) : ((Val)exps.ordering[i]).evaluate(candidate, candidate, ctx, params);
            }
            projection[i + exps.projections.length] = result;
        }
        return projection;
    }

    public List order(QueryExpressions exps, List matches, StoreContext ctx, Object[] params) {
        return this.order(exps, exps.ordering, true, matches, ctx, params);
    }

    private List order(QueryExpressions exps, Value[] orderValues, boolean projected, List matches, StoreContext ctx, Object[] params) {
        if (matches == null || matches.isEmpty() || orderValues == null || orderValues.length == 0) {
            return matches;
        }
        int results = projected ? exps.projections.length : 0;
        boolean[] asc = projected ? exps.ascending : null;
        for (int i = orderValues.length - 1; i >= 0; --i) {
            int idx = results > 0 ? results + i : -1;
            Collections.sort(matches, new OrderValueComparator((Val)orderValues[i], asc == null || asc[i], idx, ctx, params));
        }
        return matches;
    }

    public List distinct(QueryExpressions exps, boolean fromExtent, List matches) {
        if (matches == null || matches.isEmpty()) {
            return matches;
        }
        int len = exps.projections.length;
        if ((exps.distinct & 4) == 0 || fromExtent && len == 0) {
            return matches;
        }
        HashSet seen = new HashSet(matches.size());
        ArrayList distinct = null;
        ListIterator li = matches.listIterator();
        while (li.hasNext()) {
            Object key;
            Object cur = li.next();
            Object object = key = len > 0 && cur != null ? new ArrayKey((Object[])cur) : cur;
            if (seen.add(key)) {
                if (distinct == null) continue;
                distinct.add(cur);
                continue;
            }
            if (distinct != null) continue;
            distinct = new ArrayList(matches.size());
            distinct.addAll(matches.subList(0, li.previousIndex()));
        }
        return distinct == null ? matches : distinct;
    }

    @Override
    public Expression emptyExpression() {
        return new Exp();
    }

    @Override
    public Expression asExpression(Value v) {
        return new ValExpression((Val)v);
    }

    @Override
    public Expression equal(Value v1, Value v2) {
        return new EqualExpression((Val)v1, (Val)v2);
    }

    @Override
    public Expression notEqual(Value v1, Value v2) {
        return new NotEqualExpression((Val)v1, (Val)v2);
    }

    @Override
    public Expression lessThan(Value v1, Value v2) {
        return new LessThanExpression((Val)v1, (Val)v2);
    }

    @Override
    public Expression greaterThan(Value v1, Value v2) {
        return new GreaterThanExpression((Val)v1, (Val)v2);
    }

    @Override
    public Expression lessThanEqual(Value v1, Value v2) {
        return new LessThanEqualExpression((Val)v1, (Val)v2);
    }

    @Override
    public Expression greaterThanEqual(Value v1, Value v2) {
        return new GreaterThanEqualExpression((Val)v1, (Val)v2);
    }

    @Override
    public Expression isEmpty(Value v1) {
        return new IsEmptyExpression((Val)v1);
    }

    @Override
    public Expression isNotEmpty(Value v1) {
        return this.not(this.isEmpty(v1));
    }

    @Override
    public Expression contains(Value v1, Value v2) {
        return new ContainsExpression((Val)v1, (Val)v2);
    }

    @Override
    public Expression containsKey(Value v1, Value v2) {
        return new ContainsKeyExpression((Val)v1, (Val)v2);
    }

    @Override
    public Expression containsValue(Value v1, Value v2) {
        return new ContainsValueExpression((Val)v1, (Val)v2);
    }

    @Override
    public Value getMapValue(Value map, Value arg) {
        return new GetMapValue((Val)map, (Val)arg);
    }

    @Override
    public Expression isInstance(Value v1, Class c) {
        return new InstanceofExpression((Val)v1, c);
    }

    @Override
    public Expression and(Expression exp1, Expression exp2) {
        if (exp1 instanceof BindVariableExpression) {
            return new BindVariableAndExpression((BindVariableExpression)exp1, (Exp)exp2);
        }
        return new AndExpression((Exp)exp1, (Exp)exp2);
    }

    @Override
    public Expression or(Expression exp1, Expression exp2) {
        return new OrExpression((Exp)exp1, (Exp)exp2);
    }

    @Override
    public Expression not(Expression exp) {
        return new NotExpression((Exp)exp);
    }

    @Override
    public Expression bindVariable(Value var, Value val) {
        return new BindVariableExpression((BoundVariable)var, (Val)val);
    }

    @Override
    public Expression bindKeyVariable(Value var, Value val) {
        return new BindKeyVariableExpression((BoundVariable)var, (Val)val);
    }

    @Override
    public Expression bindValueVariable(Value var, Value val) {
        return new BindValueVariableExpression((BoundVariable)var, (Val)val);
    }

    @Override
    public Expression endsWith(Value v1, Value v2) {
        return new EndsWithExpression((Val)v1, (Val)v2);
    }

    @Override
    public Expression matches(Value v1, Value v2, String single, String multi, String esc) {
        return new MatchesExpression((Val)v1, (Val)v2, single, multi, esc, true);
    }

    @Override
    public Expression notMatches(Value v1, Value v2, String single, String multi, String esc) {
        return new MatchesExpression((Val)v1, (Val)v2, single, multi, esc, false);
    }

    @Override
    public Expression startsWith(Value v1, Value v2) {
        return new StartsWithExpression((Val)v1, (Val)v2);
    }

    @Override
    public Subquery newSubquery(ClassMetaData candidate, boolean subs, String alias) {
        return new SubQ(alias);
    }

    @Override
    public Path newPath() {
        return new CandidatePath();
    }

    @Override
    public Path newPath(Value val) {
        return new ValuePath((Val)val);
    }

    @Override
    public Literal newLiteral(Object val, int parseType) {
        return new Lit(val, parseType);
    }

    @Override
    public Literal newTypeLiteral(Object val, int parseType) {
        return new TypeLit(val, parseType);
    }

    @Override
    public Value getThis() {
        return new This();
    }

    @Override
    public Value getNull() {
        return NULL;
    }

    @Override
    public <T extends Date> Value getCurrentDate(Class<T> dateType) {
        return new CurrentDate(dateType);
    }

    @Override
    public <T extends Date> Value getCurrentTime(Class<T> dateType) {
        return new CurrentDate(dateType);
    }

    @Override
    public <T extends Date> Value getCurrentTimestamp(Class<T> dateType) {
        return new CurrentDate(dateType);
    }

    @Override
    public <T extends Temporal> Value getCurrentLocalDateTime(Class<T> temporalType) {
        return new CurrentTemporal(temporalType);
    }

    @Override
    public Value getDateTimeField(DateTimeExtractField field, Value value) {
        return new ExtractDateTimeField(field, (Val)value);
    }

    @Override
    public Value getDateTimePart(DateTimeExtractPart part, Value value) {
        return new ExtractDateTimePart(part, (Val)value);
    }

    @Override
    public Parameter newParameter(Object name, Class type) {
        return new Param(name, type);
    }

    @Override
    public Parameter newCollectionValuedParameter(Object name, Class type) {
        return new CollectionParam(name, type);
    }

    @Override
    public Value newExtension(FilterListener listener, Value target, Value arg) {
        return new Extension(listener, (Val)target, (Val)arg);
    }

    @Override
    public Value newAggregate(AggregateListener listener, Value arg) {
        return new Aggregate(listener, (Val)arg);
    }

    @Override
    public Arguments newArgumentList(Value val1, Value val2) {
        return new Args(val1, val2);
    }

    @Override
    public Arguments newArgumentList(Value ... values) {
        return new Args(values);
    }

    @Override
    public Value newUnboundVariable(String name, Class type) {
        UnboundVariable var = new UnboundVariable(type);
        if (this._unbounds == null) {
            this._unbounds = new ArrayList<UnboundVariable>(3);
        }
        this._unbounds.add(var);
        return var;
    }

    @Override
    public Value newBoundVariable(String name, Class type) {
        return new BoundVariable(type);
    }

    @Override
    public Value cast(Value val, Class cls) {
        if (val instanceof CandidatePath) {
            ((CandidatePath)val).castTo(cls);
        } else if (val instanceof BoundVariable) {
            ((BoundVariable)val).castTo(cls);
        } else {
            val = new Cast((Val)val, cls);
        }
        return val;
    }

    @Override
    public Value add(Value val1, Value val2) {
        return new Add((Val)val1, (Val)val2);
    }

    @Override
    public Value subtract(Value val1, Value val2) {
        return new Subtract((Val)val1, (Val)val2);
    }

    @Override
    public Value multiply(Value val1, Value val2) {
        return new Multiply((Val)val1, (Val)val2);
    }

    @Override
    public Value divide(Value val1, Value val2) {
        return new Divide((Val)val1, (Val)val2);
    }

    @Override
    public Value mod(Value val1, Value val2) {
        return new Mod((Val)val1, (Val)val2);
    }

    @Override
    public Value abs(Value val) {
        return new Abs((Val)val);
    }

    @Override
    public Value ceiling(Value val) {
        return new Ceiling((Val)val);
    }

    @Override
    public Value exp(Value val) {
        return new Exponential((Val)val);
    }

    @Override
    public Value floor(Value val) {
        return new Floor((Val)val);
    }

    @Override
    public Value ln(Value val) {
        return new NaturalLogarithm((Val)val);
    }

    @Override
    public Value sign(Value val) {
        return new Sign((Val)val);
    }

    @Override
    public Value power(Value base, Value exponent) {
        return new Power((Val)base, (Val)exponent);
    }

    @Override
    public Value round(Value num, Value precision) {
        return new Round((Val)num, (Val)precision);
    }

    @Override
    public Value indexOf(Value val1, Value val2) {
        return new IndexOf((Val)val1, (Val)val2);
    }

    @Override
    public Value concat(Value val1, Value val2) {
        return new Concat((Val)val1, (Val)val2);
    }

    @Override
    public Value stringLength(Value str) {
        return new StringLength((Val)str);
    }

    @Override
    public Value trim(Value str, Value trimChar, Boolean where) {
        return new Trim((Val)str, (Val)trimChar, where);
    }

    @Override
    public Value sqrt(Value val) {
        return new Sqrt((Val)val);
    }

    @Override
    public Value substring(Value val1, Value val2) {
        return new Substring((Val)val1, (Val)val2);
    }

    @Override
    public Value toUpperCase(Value val) {
        return new ToUpperCase((Val)val);
    }

    @Override
    public Value toLowerCase(Value val) {
        return new ToLowerCase((Val)val);
    }

    @Override
    public Value avg(Value val) {
        return new Avg((Val)val);
    }

    @Override
    public Value count(Value val) {
        return new Count((Val)val);
    }

    @Override
    public Value distinct(Value val) {
        return new Distinct((Val)val);
    }

    @Override
    public Value max(Value val) {
        return new Max((Val)val);
    }

    @Override
    public Value min(Value val) {
        return new Min((Val)val);
    }

    @Override
    public Value sum(Value val) {
        return new Sum((Val)val);
    }

    @Override
    public Value any(Value val) {
        return new Any((Val)val);
    }

    @Override
    public Value all(Value val) {
        return new All((Val)val);
    }

    @Override
    public Value size(Value val) {
        return new Size((Val)val);
    }

    @Override
    public Value index(Value val) {
        return new Index((Val)val);
    }

    @Override
    public Value type(Value val) {
        return new Type((Val)val);
    }

    @Override
    public Value mapEntry(Value key, Value val) {
        throw new UnsupportedException("not implemented yet");
    }

    @Override
    public Value mapKey(Value key, Value val) {
        throw new UnsupportedException("not implemented yet");
    }

    @Override
    public Value getKey(Value val) {
        throw new UnsupportedException("not implemented yet");
    }

    @Override
    public Value getObjectId(Value val) {
        return new GetObjectId((Val)val);
    }

    @Override
    public Value generalCaseExpression(Expression[] exp, Value val) {
        Exp[] exps = new Exp[exp.length];
        for (int i = 0; i < exp.length; ++i) {
            exps[i] = (Exp)exp[i];
        }
        return new GeneralCase(exps, (Val)val);
    }

    @Override
    public Value simpleCaseExpression(Value caseOperand, Expression[] exp, Value val) {
        Exp[] exps = new Exp[exp.length];
        for (int i = 0; i < exp.length; ++i) {
            exps[i] = (Exp)exp[i];
        }
        return new SimpleCase((Val)caseOperand, exps, (Val)val);
    }

    @Override
    public Expression whenCondition(Expression exp, Value val) {
        return new WhenCondition((Exp)exp, (Val)val);
    }

    @Override
    public Expression whenScalar(Value val1, Value val2) {
        return new WhenScalar((Val)val1, (Val)val2);
    }

    @Override
    public Value coalesceExpression(Value[] val) {
        Val[] vals = new Val[val.length];
        for (int i = 0; i < val.length; ++i) {
            vals[i] = (Val)val[i];
        }
        return new Coalesce(vals);
    }

    @Override
    public Value nullIfExpression(Value val1, Value val2) {
        return new NullIf((Val)val1, (Val)val2);
    }

    @Override
    public Value newFunction(String functionName, Class<?> resultType, Value ... args) {
        throw new AbstractMethodError();
    }

    @Override
    public boolean isVerticalType(Value val) {
        return false;
    }

    private static class OrderValueComparator
    implements Comparator {
        private final StoreContext _ctx;
        private final Val _val;
        private final boolean _asc;
        private final int _idx;
        private final Object[] _params;

        private OrderValueComparator(Val val, boolean asc, int idx, StoreContext ctx, Object[] params) {
            this._ctx = ctx;
            this._val = val;
            this._asc = asc;
            this._idx = idx;
            this._params = params;
        }

        public int compare(Object o1, Object o2) {
            if (this._idx != -1) {
                o1 = ((Object[])o1)[this._idx];
                o2 = ((Object[])o2)[this._idx];
            } else {
                o1 = this._val.evaluate(o1, o1, this._ctx, this._params);
                o2 = this._val.evaluate(o2, o2, this._ctx, this._params);
            }
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return this._asc ? 1 : -1;
            }
            if (o2 == null) {
                return this._asc ? -1 : 1;
            }
            if (o1 instanceof Boolean && o2 instanceof Boolean) {
                int i1 = (Boolean)o1 != false ? 1 : 0;
                int i2 = (Boolean)o2 != false ? 1 : 0;
                return i1 - i2;
            }
            try {
                if (this._asc) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return ((Comparable)o2).compareTo(o1);
            }
            catch (ClassCastException cce) {
                Localizer loc = Localizer.forPackage(InMemoryExpressionFactory.class);
                throw new UserException(loc.get("not-comp", o1, o2));
            }
        }
    }

    private static class ArrayKey {
        private final Object[] _arr;

        public ArrayKey(Object[] arr) {
            this._arr = arr;
        }

        public int hashCode() {
            int rs = 17;
            for (Object o : this._arr) {
                rs = 37 * rs + (o == null ? 0 : o.hashCode());
            }
            return rs;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null) {
                return false;
            }
            Object[] arr = ((ArrayKey)other)._arr;
            if (this._arr.length != arr.length) {
                return false;
            }
            for (int i = 0; i < this._arr.length; ++i) {
                if (Objects.equals(this._arr[i], arr[i])) continue;
                return false;
            }
            return true;
        }
    }
}

