/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component.creation;

import jakarta.annotation.Priority;
import jakarta.enterprise.inject.UnproxyableResolutionException;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanAttributes;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.component.creation.UnproxyableBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.WebBeansUtil;

public class ManagedBeanBuilder<T, M extends ManagedBean<T>> {
    protected final WebBeansContext webBeansContext;
    protected final AnnotatedType<T> annotatedType;
    protected final BeanAttributes<T> beanAttributes;
    protected final boolean ignoreFinalMethods;

    public ManagedBeanBuilder(WebBeansContext webBeansContext, AnnotatedType<T> annotatedType, BeanAttributes<T> beanAttributes, boolean ignoreFinalMethods) {
        Asserts.assertNotNull(webBeansContext, "WebBeansContetx");
        Asserts.assertNotNull(annotatedType, "annotated type");
        Asserts.assertNotNull(beanAttributes, "beanAttributes");
        this.webBeansContext = webBeansContext;
        this.annotatedType = annotatedType;
        this.beanAttributes = beanAttributes;
        this.ignoreFinalMethods = ignoreFinalMethods;
    }

    public M getBean() {
        ManagedBean<T> bean = new ManagedBean<T>(this.webBeansContext, WebBeansType.MANAGED, this.annotatedType, this.beanAttributes, this.annotatedType.getJavaClass());
        bean.setEnabled(this.webBeansContext.getWebBeansUtil().isBeanEnabled(this.beanAttributes, this.annotatedType, bean.getStereotypes()));
        this.checkStereotypes(bean.getStereotypes());
        this.webBeansContext.getWebBeansUtil().checkManagedBeanCondition(this.annotatedType);
        WebBeansUtil.checkGenericType(this.annotatedType.getJavaClass(), this.beanAttributes.getScope());
        this.webBeansContext.getWebBeansUtil().validateBeanInjection(bean);
        UnproxyableResolutionException lazyException = this.webBeansContext.getDeploymentValidationService().validateProxyable(bean, this.ignoreFinalMethods);
        if (lazyException == null) {
            return (M)bean;
        }
        return (M)new UnproxyableBean<T>(this.webBeansContext, WebBeansType.MANAGED, this.beanAttributes, this.annotatedType, this.annotatedType.getJavaClass(), lazyException);
    }

    private void checkStereotypes(Set<Class<? extends Annotation>> stereotypes) {
        long stereoTypesWithPriority;
        if (stereotypes != null && stereotypes.size() > 1 && (stereoTypesWithPriority = stereotypes.stream().filter(s -> s.getAnnotation(Priority.class) != null).count()) > 1L) {
            throw new WebBeansConfigurationException("More than one Stereotype with @Priority on a bean is not allowed!");
        }
    }
}

