/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.manager;

import jakarta.transaction.SystemException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.geronimo.transaction.manager.LogException;
import org.apache.geronimo.transaction.manager.NamedXAResource;
import org.apache.geronimo.transaction.manager.NamedXAResourceFactory;
import org.apache.geronimo.transaction.manager.TransactionImpl;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;

public class CommitTask
implements Runnable {
    private static final Logger log = Logger.getLogger(CommitTask.class.getName());
    private final Xid xid;
    private final List<TransactionImpl.TransactionBranch> rms;
    private final Object logMark;
    private final TransactionManagerImpl txManager;
    private int count = 0;
    private int status;
    private XAException cause;
    private boolean evercommit;

    public CommitTask(Xid xid, List<TransactionImpl.TransactionBranch> rms, Object logMark, TransactionManagerImpl txManager) {
        this.xid = xid;
        this.rms = rms;
        this.logMark = logMark;
        this.txManager = txManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CommitTask commitTask = this;
        synchronized (commitTask) {
            this.status = 8;
        }
        int index2 = 0;
        while (index2 < this.rms.size()) {
            TransactionImpl.TransactionBranch manager = this.rms.get(index2);
            try {
                try {
                    manager.getCommitter().commit(manager.getBranchId(), false);
                    this.remove(index2);
                    this.evercommit = true;
                }
                catch (XAException e) {
                    log.log(Level.SEVERE, "Unexpected exception committing " + manager.getCommitter() + "; continuing to commit other RMs", e);
                    if (e.errorCode == 6) {
                        this.remove(index2);
                        log.info("Transaction has been heuristically rolled back");
                        this.cause = e;
                        manager.getCommitter().forget(manager.getBranchId());
                        continue;
                    }
                    if (e.errorCode == 5) {
                        this.remove(index2);
                        log.info("Transaction has been heuristically committed and rolled back");
                        this.cause = e;
                        this.evercommit = true;
                        manager.getCommitter().forget(manager.getBranchId());
                        continue;
                    }
                    if (e.errorCode == 7) {
                        this.remove(index2);
                        log.info("Transaction has been heuristically committed");
                        this.evercommit = true;
                        manager.getCommitter().forget(manager.getBranchId());
                        continue;
                    }
                    if (e.errorCode == 4) {
                        ++index2;
                        continue;
                    }
                    if (e.errorCode == -7) {
                        if (manager.getCommitter() instanceof NamedXAResource) {
                            String xaResourceName = manager.getResourceName();
                            NamedXAResourceFactory namedXAResourceFactory = this.txManager.getNamedXAResourceFactory(xaResourceName);
                            if (namedXAResourceFactory != null) {
                                try {
                                    TransactionImpl.ReturnableTransactionBranch newManager = new TransactionImpl.ReturnableTransactionBranch(manager.getBranchXid(), namedXAResourceFactory);
                                    this.remove(index2);
                                    this.rms.add(index2, newManager);
                                }
                                catch (SystemException e1) {
                                    ++index2;
                                }
                                continue;
                            }
                            ++index2;
                            continue;
                        }
                        this.remove(index2);
                        this.cause = e;
                        continue;
                    }
                    this.remove(index2);
                    this.cause = e;
                }
            }
            catch (XAException e) {
                if (e.errorCode == -4) continue;
                this.cause = e;
            }
        }
        if (this.rms.isEmpty()) {
            try {
                this.txManager.getTransactionLog().commit(this.xid, this.logMark);
                CommitTask index2 = this;
                synchronized (index2) {
                    this.status = 3;
                }
            }
            catch (LogException e) {
                log.log(Level.SEVERE, "Unexpected exception logging commit completion for xid " + this.xid, e);
                this.cause = (XAException)new XAException("Unexpected error logging commit completion for xid " + this.xid).initCause(e);
            }
        } else {
            CommitTask commitTask2 = this;
            synchronized (commitTask2) {
                this.status = 5;
            }
            this.txManager.getRetryScheduler().retry(this, this.count++);
        }
    }

    private void remove(int index) {
        TransactionImpl.TransactionBranch manager = this.rms.remove(index);
        if (manager instanceof TransactionImpl.ReturnableTransactionBranch) {
            ((TransactionImpl.ReturnableTransactionBranch)manager).returnXAResource();
        }
    }

    public XAException getCause() {
        return this.cause;
    }

    public boolean isEvercommit() {
        return this.evercommit;
    }

    public int getStatus() {
        return this.status;
    }
}

