/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.config.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.config.ConfigurationProperties;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.xmlsec.agreement.impl.DigestMethod;
import org.opensaml.xmlsec.agreement.impl.KANonce;
import org.opensaml.xmlsec.derivation.impl.ConcatKDF;
import org.opensaml.xmlsec.derivation.impl.PBKDF2;
import org.opensaml.xmlsec.encryption.support.ChainingEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.KeyAgreementEncryptionConfiguration;
import org.opensaml.xmlsec.encryption.support.RSAOAEPParameters;
import org.opensaml.xmlsec.encryption.support.SimpleKeyInfoReferenceEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.SimpleRetrievalMethodEncryptedKeyResolver;
import org.opensaml.xmlsec.impl.BasicDecryptionConfiguration;
import org.opensaml.xmlsec.impl.BasicEncryptionConfiguration;
import org.opensaml.xmlsec.impl.BasicSignatureSigningConfiguration;
import org.opensaml.xmlsec.impl.BasicSignatureValidationConfiguration;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorManager;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;
import org.opensaml.xmlsec.keyinfo.impl.BasicKeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.impl.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.KeyAgreementKeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.impl.KeyInfoProvider;
import org.opensaml.xmlsec.keyinfo.impl.X509KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.impl.provider.DEREncodedKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.DSAKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.ECKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.InlineX509DataProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.RSAKeyValueProvider;
import org.slf4j.Logger;

public class DefaultSecurityConfigurationBootstrap {
    @Nonnull
    @NotEmpty
    public static final String CONFIG_PROPERTY_ECDH_DEFAULT_KDF = "opensaml.config.ecdh.defaultKDF";
    @Nonnull
    @NotEmpty
    public static final String CONCATKDF = "ConcatKDF";
    @Nonnull
    @NotEmpty
    public static final String PBKDF2 = "PBKDF2";
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSecurityConfigurationBootstrap.class);

    protected DefaultSecurityConfigurationBootstrap() {
    }

    @Nonnull
    public static BasicEncryptionConfiguration buildDefaultEncryptionConfiguration() {
        BasicEncryptionConfiguration config = new BasicEncryptionConfiguration();
        config.setExcludedAlgorithms(CollectionSupport.singletonList((Object)"http://www.w3.org/2001/04/xmlenc#rsa-1_5"));
        config.setDataEncryptionAlgorithms(CollectionSupport.listOf((Object[])new String[]{"http://www.w3.org/2001/04/xmlenc#aes128-cbc", "http://www.w3.org/2001/04/xmlenc#aes192-cbc", "http://www.w3.org/2001/04/xmlenc#aes256-cbc", "http://www.w3.org/2001/04/xmlenc#tripledes-cbc"}));
        config.setKeyTransportEncryptionAlgorithms(CollectionSupport.listOf((Object[])new String[]{"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", "http://www.w3.org/2001/04/xmlenc#kw-aes128", "http://www.w3.org/2001/04/xmlenc#kw-aes192", "http://www.w3.org/2001/04/xmlenc#kw-aes256", "http://www.w3.org/2001/04/xmlenc#kw-tripledes"}));
        config.setRSAOAEPParameters(new RSAOAEPParameters("http://www.w3.org/2000/09/xmldsig#sha1", "http://www.w3.org/2009/xmlenc11#mgf1sha1", null));
        config.setKeyAgreementConfigurations(DefaultSecurityConfigurationBootstrap.buildKeyAgreementConfigurations());
        config.setDataKeyInfoGeneratorManager(DefaultSecurityConfigurationBootstrap.buildDataEncryptionKeyInfoGeneratorManager());
        config.setKeyTransportKeyInfoGeneratorManager(DefaultSecurityConfigurationBootstrap.buildKeyTransportEncryptionKeyInfoGeneratorManager());
        return config;
    }

    @Nonnull
    protected static Map<String, KeyAgreementEncryptionConfiguration> buildKeyAgreementConfigurations() {
        HashMap<String, KeyAgreementEncryptionConfiguration> kaConfigs = new HashMap<String, KeyAgreementEncryptionConfiguration>();
        try {
            ConfigurationProperties props = ConfigurationService.getConfigurationProperties();
            KeyAgreementEncryptionConfiguration ecConfig = new KeyAgreementEncryptionConfiguration();
            ecConfig.setAlgorithm("http://www.w3.org/2009/xmlenc11#ECDH-ES");
            String ecKDF = props.getProperty(CONFIG_PROPERTY_ECDH_DEFAULT_KDF, CONCATKDF);
            if (CONCATKDF.equals(ecKDF)) {
                ConcatKDF ecConcatKDF = new ConcatKDF();
                ecConcatKDF.setAlgorithmID("00");
                ecConcatKDF.setPartyUInfo("00");
                ecConcatKDF.setPartyVInfo("00");
                ecConcatKDF.initialize();
                ecConfig.setParameters((Collection)CollectionSupport.singleton((Object)((Object)ecConcatKDF)));
            } else if (PBKDF2.equals(ecKDF)) {
                PBKDF2 ecPBKDF2 = new PBKDF2();
                ecPBKDF2.initialize();
                ecConfig.setParameters(Set.of(ecPBKDF2));
            } else {
                LOG.warn("Saw unknown value for ECDH KDF '{}', omitting global ECDH KDF configuration", (Object)ecKDF);
                ecConfig.setParameters((Collection)CollectionSupport.emptySet());
            }
            kaConfigs.put("EC", ecConfig);
            KeyAgreementEncryptionConfiguration dhConfig = new KeyAgreementEncryptionConfiguration();
            dhConfig.setAlgorithm("http://www.w3.org/2001/04/xmlenc#dh");
            DigestMethod digestMethod = new DigestMethod();
            digestMethod.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256");
            digestMethod.initialize();
            KANonce nonce = new KANonce();
            nonce.initialize();
            dhConfig.setParameters((Collection)CollectionSupport.setOf((Object)((Object)digestMethod), (Object)((Object)nonce)));
            kaConfigs.put("DH", dhConfig);
        }
        catch (ComponentInitializationException e) {
            LOG.error("Initialization failure on global key agreement encryption configuration, will be unusable", (Throwable)e);
        }
        return kaConfigs;
    }

    @Nonnull
    public static BasicDecryptionConfiguration buildDefaultDecryptionConfiguration() {
        BasicDecryptionConfiguration config = new BasicDecryptionConfiguration();
        config.setExcludedAlgorithms(CollectionSupport.singletonList((Object)"http://www.w3.org/2001/04/xmlenc#rsa-1_5"));
        config.setEncryptedKeyResolver(DefaultSecurityConfigurationBootstrap.buildBasicEncryptedKeyResolver());
        return config;
    }

    @Nonnull
    public static BasicSignatureSigningConfiguration buildDefaultSignatureSigningConfiguration() {
        BasicSignatureSigningConfiguration config = new BasicSignatureSigningConfiguration();
        config.setExcludedAlgorithms(CollectionSupport.listOf((Object[])new String[]{"http://www.w3.org/2001/04/xmldsig-more#md5", "http://www.w3.org/2001/04/xmldsig-more#rsa-md5", "http://www.w3.org/2001/04/xmldsig-more#hmac-md5"}));
        config.setSignatureAlgorithms(CollectionSupport.listOf((Object[])new String[]{"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", "http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1", "http://www.w3.org/2000/09/xmldsig#dsa-sha1", "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256", "http://www.w3.org/2001/04/xmldsig-more#hmac-sha384", "http://www.w3.org/2001/04/xmldsig-more#hmac-sha512", "http://www.w3.org/2000/09/xmldsig#hmac-sha1"}));
        config.setSignatureReferenceDigestMethods(List.of("http://www.w3.org/2001/04/xmlenc#sha256", "http://www.w3.org/2001/04/xmldsig-more#sha384", "http://www.w3.org/2001/04/xmlenc#sha512", "http://www.w3.org/2000/09/xmldsig#sha1"));
        config.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        config.setKeyInfoGeneratorManager(DefaultSecurityConfigurationBootstrap.buildSignatureKeyInfoGeneratorManager());
        return config;
    }

    @Nonnull
    public static BasicSignatureValidationConfiguration buildDefaultSignatureValidationConfiguration() {
        BasicSignatureValidationConfiguration config = new BasicSignatureValidationConfiguration();
        config.setExcludedAlgorithms(List.of("http://www.w3.org/2001/04/xmldsig-more#md5", "http://www.w3.org/2001/04/xmldsig-more#rsa-md5", "http://www.w3.org/2001/04/xmldsig-more#hmac-md5"));
        return config;
    }

    @Nonnull
    protected static EncryptedKeyResolver buildBasicEncryptedKeyResolver() {
        ArrayList<Object> resolverChain = new ArrayList<Object>();
        resolverChain.add(new InlineEncryptedKeyResolver());
        resolverChain.add(new SimpleRetrievalMethodEncryptedKeyResolver());
        resolverChain.add(new SimpleKeyInfoReferenceEncryptedKeyResolver());
        return new ChainingEncryptedKeyResolver(resolverChain);
    }

    @Nonnull
    public static KeyInfoCredentialResolver buildBasicInlineKeyInfoCredentialResolver() {
        ArrayList<KeyInfoProvider> providers = new ArrayList<KeyInfoProvider>();
        providers.add(new RSAKeyValueProvider());
        providers.add(new DSAKeyValueProvider());
        providers.add(new ECKeyValueProvider());
        providers.add(new DEREncodedKeyValueProvider());
        providers.add(new InlineX509DataProvider());
        BasicProviderKeyInfoCredentialResolver resolver = new BasicProviderKeyInfoCredentialResolver(providers);
        return resolver;
    }

    @Nonnull
    protected static NamedKeyInfoGeneratorManager buildDataEncryptionKeyInfoGeneratorManager() {
        KeyAgreementKeyInfoGeneratorFactory keyAgreementFactory = new KeyAgreementKeyInfoGeneratorFactory();
        NamedKeyInfoGeneratorManager manager = DefaultSecurityConfigurationBootstrap.buildBasicKeyInfoGeneratorManager();
        manager.getDefaultManager().registerFactory((KeyInfoGeneratorFactory)keyAgreementFactory);
        return manager;
    }

    @Nonnull
    protected static NamedKeyInfoGeneratorManager buildKeyTransportEncryptionKeyInfoGeneratorManager() {
        KeyAgreementKeyInfoGeneratorFactory keyAgreementFactory = new KeyAgreementKeyInfoGeneratorFactory();
        NamedKeyInfoGeneratorManager manager = DefaultSecurityConfigurationBootstrap.buildBasicKeyInfoGeneratorManager();
        manager.getDefaultManager().registerFactory((KeyInfoGeneratorFactory)keyAgreementFactory);
        return manager;
    }

    @Nonnull
    protected static NamedKeyInfoGeneratorManager buildSignatureKeyInfoGeneratorManager() {
        NamedKeyInfoGeneratorManager namedManager = new NamedKeyInfoGeneratorManager();
        namedManager.setUseDefaultManager(true);
        KeyInfoGeneratorManager defaultManager = namedManager.getDefaultManager();
        BasicKeyInfoGeneratorFactory basicFactory = new BasicKeyInfoGeneratorFactory();
        basicFactory.setEmitPublicKeyValue(true);
        basicFactory.setEmitPublicDEREncodedKeyValue(true);
        basicFactory.setEmitKeyNames(true);
        X509KeyInfoGeneratorFactory x509Factory = new X509KeyInfoGeneratorFactory();
        x509Factory.setEmitEntityCertificate(true);
        x509Factory.setEmitEntityCertificateChain(true);
        defaultManager.registerFactory((KeyInfoGeneratorFactory)basicFactory);
        defaultManager.registerFactory((KeyInfoGeneratorFactory)x509Factory);
        return namedManager;
    }

    @Nonnull
    public static NamedKeyInfoGeneratorManager buildBasicKeyInfoGeneratorManager() {
        NamedKeyInfoGeneratorManager namedManager = new NamedKeyInfoGeneratorManager();
        namedManager.setUseDefaultManager(true);
        KeyInfoGeneratorManager defaultManager = namedManager.getDefaultManager();
        BasicKeyInfoGeneratorFactory basicFactory = new BasicKeyInfoGeneratorFactory();
        basicFactory.setEmitPublicKeyValue(true);
        basicFactory.setEmitPublicDEREncodedKeyValue(true);
        basicFactory.setEmitKeyNames(true);
        X509KeyInfoGeneratorFactory x509Factory = new X509KeyInfoGeneratorFactory();
        x509Factory.setEmitEntityCertificate(true);
        defaultManager.registerFactory((KeyInfoGeneratorFactory)basicFactory);
        defaultManager.registerFactory((KeyInfoGeneratorFactory)x509Factory);
        return namedManager;
    }
}

