/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.impl;

import java.util.NoSuchElementException;
import java.util.function.IntFunction;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.impl.JCasHashMapSubMap;
import org.apache.uima.util.IteratorNvc;

public class JCasHashMap
implements Iterable<TOP> {
    static final boolean TUNE = false;
    static final boolean check = false;
    static int DEFAULT_CONCURRENCY_LEVEL = 1 + (int)((double)Misc.numberOfCores * (Misc.numberOfCores > 64 ? 0.08 : (Misc.numberOfCores > 32 ? 0.1 : (Misc.numberOfCores > 16 ? 0.2 : (Misc.numberOfCores > 8 ? 0.3 : 0.4)))));
    private final float loadFactor = 0.6f;
    private final int initialCapacity;
    private final int concurrencyLevel;
    private final int concurrencyBitmask;
    private final int concurrencyLevelBits;
    private final JCasHashMapSubMap[] subMaps;
    private final int subMapInitialCapacity;
    private final JCasHashMapSubMap oneSubmap;
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;
    private static final int seed = 969059159;

    static int getDEFAULT_CONCURRENCY_LEVEL() {
        return DEFAULT_CONCURRENCY_LEVEL;
    }

    static void setDEFAULT_CONCURRENCY_LEVEL(int dEFAULT_CONCURRENCY_LEVEL) {
        DEFAULT_CONCURRENCY_LEVEL = Misc.nextHigherPowerOf2(dEFAULT_CONCURRENCY_LEVEL);
    }

    public JCasHashMap(int capacity) {
        this(capacity, capacity / DEFAULT_CONCURRENCY_LEVEL < 32 ? Misc.nextHigherPowerOf2(Math.max(1, capacity / 32)) : DEFAULT_CONCURRENCY_LEVEL);
    }

    JCasHashMap(int capacity, int aConcurrencyLevel) {
        if (aConcurrencyLevel < 1 || capacity < 1) {
            throw new RuntimeException(String.format("capacity %d and concurrencyLevel %d must be > 0", capacity, aConcurrencyLevel));
        }
        this.concurrencyLevel = Misc.nextHigherPowerOf2(aConcurrencyLevel);
        this.concurrencyBitmask = this.concurrencyLevel - 1;
        this.concurrencyLevelBits = Integer.numberOfTrailingZeros(this.concurrencyLevel);
        if ((capacity = Math.max(32, Misc.nextHigherPowerOf2(capacity))) / this.concurrencyLevel < 32) {
            capacity = 32 * this.concurrencyLevel;
        }
        this.initialCapacity = capacity;
        this.subMaps = new JCasHashMapSubMap[this.concurrencyLevel];
        this.subMapInitialCapacity = this.initialCapacity / this.concurrencyLevel;
        for (int i = 0; i < this.concurrencyLevel; ++i) {
            this.subMaps[i] = new JCasHashMapSubMap(0.6f, this.subMapInitialCapacity, this.concurrencyLevelBits);
        }
        this.oneSubmap = this.concurrencyLevel == 1 ? this.subMaps[0] : null;
    }

    static boolean concurrencyLimitedByInitialCapacity(int currentConcurrencyLevel, int curMapSize) {
        if (DEFAULT_CONCURRENCY_LEVEL <= currentConcurrencyLevel) {
            return false;
        }
        int submapSize = curMapSize / DEFAULT_CONCURRENCY_LEVEL;
        int newConcurrencyLevel = submapSize < 32 ? Misc.nextHigherPowerOf2(Math.max(1, curMapSize / 32)) : DEFAULT_CONCURRENCY_LEVEL;
        return newConcurrencyLevel > currentConcurrencyLevel;
    }

    static int sizeAdjustedConcurrency(int curMapSize) {
        int submapSize = curMapSize / DEFAULT_CONCURRENCY_LEVEL;
        int newConcurrencyLevel = submapSize < 32 ? Misc.nextHigherPowerOf2(Math.max(1, curMapSize / 32)) : DEFAULT_CONCURRENCY_LEVEL;
        return Math.max(32 * newConcurrencyLevel, curMapSize / 2);
    }

    public synchronized void clear() {
        for (JCasHashMapSubMap m : this.subMaps) {
            m.clear();
        }
    }

    private JCasHashMapSubMap getSubMap(int hash) {
        return null != this.oneSubmap ? this.oneSubmap : this.subMaps[hash & this.concurrencyBitmask];
    }

    public final TOP putIfAbsent(int key, IntFunction<TOP> creator) {
        int hash = JCasHashMap.hashInt(key);
        TOP r = this.getSubMap(hash).putIfAbsent(key, hash >>> this.concurrencyLevelBits, creator);
        return r;
    }

    public final TOP get(int key) {
        int hash = JCasHashMap.hashInt(key);
        TOP r = this.getSubMap(hash).get(key, hash >>> this.concurrencyLevelBits);
        return r;
    }

    public final TOP put(TOP value) {
        return this.put(value._id(), value);
    }

    public TOP put(int key, TOP value) {
        int hash = JCasHashMap.hashInt(key);
        return this.getSubMap(hash).put(key, value, hash >>> this.concurrencyLevelBits);
    }

    public static final int hashInt(int k1) {
        k1 *= -862048943;
        k1 = Integer.rotateLeft(k1, 15);
        int h1 = 0x39C2AB57 ^ (k1 *= 461845907);
        h1 = Integer.rotateLeft(h1, 13);
        h1 = h1 * 5 + -430675100;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }

    int[] getCapacities() {
        int[] r = new int[this.subMaps.length];
        int i = 0;
        for (JCasHashMapSubMap subMap : this.subMaps) {
            r[i++] = subMap.table.length;
        }
        return r;
    }

    int[] getSubSizes() {
        int[] r = new int[this.subMaps.length];
        int i = 0;
        for (JCasHashMapSubMap subMap : this.subMaps) {
            r[i++] = subMap.size;
        }
        return r;
    }

    int getCapacity() {
        int r = 0;
        for (JCasHashMapSubMap subMap : this.subMaps) {
            r += subMap.table.length;
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getApproximateSize() {
        int s = 0;
        JCasHashMapSubMap[] jCasHashMapSubMapArray = this.subMaps;
        int n = jCasHashMapSubMapArray.length;
        for (int i = 0; i < n; ++i) {
            JCasHashMapSubMap subMap;
            JCasHashMapSubMap jCasHashMapSubMap = subMap = jCasHashMapSubMapArray[i];
            synchronized (jCasHashMapSubMap) {
                s += subMap.size;
                continue;
            }
        }
        return s;
    }

    public void showHistogram() {
    }

    public int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    @Override
    public IteratorNvc<TOP> iterator() {
        return new IteratorNvc<TOP>(){
            int i_submap = 0;
            IteratorNvc<TOP> current_iterator = JCasHashMap.access$000(JCasHashMap.this)[0].iterator();
            {
                this.maybeMoveToNextValidSubmap();
            }

            void maybeMoveToNextValidSubmap() {
                while (!this.current_iterator.hasNext()) {
                    ++this.i_submap;
                    if (this.i_submap >= JCasHashMap.this.subMaps.length) {
                        return;
                    }
                    this.current_iterator = JCasHashMap.this.subMaps[this.i_submap].iterator();
                }
            }

            @Override
            public boolean hasNext() {
                this.maybeMoveToNextValidSubmap();
                return this.i_submap < JCasHashMap.this.subMaps.length;
            }

            @Override
            public TOP next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.nextNvc();
            }

            @Override
            public TOP nextNvc() {
                return this.current_iterator.nextNvc();
            }
        };
    }
}

