/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.plugins.baseplugin.conditions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.unomi.api.Consent;
import org.apache.unomi.api.CustomItem;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Metadata;
import org.apache.unomi.api.MetadataItem;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.TimestampedItem;
import org.apache.unomi.api.campaigns.Campaign;
import org.apache.unomi.api.goals.Goal;
import org.apache.unomi.api.rules.Rule;
import org.apache.unomi.plugins.baseplugin.conditions.accessors.CampaignAccessor;
import org.apache.unomi.plugins.baseplugin.conditions.accessors.ConsentAccessor;
import org.apache.unomi.plugins.baseplugin.conditions.accessors.CustomItemAccessor;
import org.apache.unomi.plugins.baseplugin.conditions.accessors.EventAccessor;
import org.apache.unomi.plugins.baseplugin.conditions.accessors.GoalAccessor;
import org.apache.unomi.plugins.baseplugin.conditions.accessors.HardcodedPropertyAccessor;
import org.apache.unomi.plugins.baseplugin.conditions.accessors.ItemAccessor;
import org.apache.unomi.plugins.baseplugin.conditions.accessors.MapAccessor;
import org.apache.unomi.plugins.baseplugin.conditions.accessors.MetadataAccessor;
import org.apache.unomi.plugins.baseplugin.conditions.accessors.MetadataItemAccessor;
import org.apache.unomi.plugins.baseplugin.conditions.accessors.ProfileAccessor;
import org.apache.unomi.plugins.baseplugin.conditions.accessors.RuleAccessor;
import org.apache.unomi.plugins.baseplugin.conditions.accessors.SessionAccessor;
import org.apache.unomi.plugins.baseplugin.conditions.accessors.TimestampedItemAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HardcodedPropertyAccessorRegistry {
    private static final Logger logger = LoggerFactory.getLogger((String)HardcodedPropertyAccessorRegistry.class.getName());
    protected Map<Class<?>, HardcodedPropertyAccessor> propertyAccessors = new HashMap();
    protected Map<Class<?>, List<Class<?>>> cachedClassAncestors = new HashMap();

    public HardcodedPropertyAccessorRegistry() {
        this.propertyAccessors.put(Item.class, new ItemAccessor(this));
        this.propertyAccessors.put(MetadataItem.class, new MetadataItemAccessor(this));
        this.propertyAccessors.put(Metadata.class, new MetadataAccessor(this));
        this.propertyAccessors.put(TimestampedItem.class, new TimestampedItemAccessor(this));
        this.propertyAccessors.put(Event.class, new EventAccessor(this));
        this.propertyAccessors.put(Profile.class, new ProfileAccessor(this));
        this.propertyAccessors.put(Consent.class, new ConsentAccessor(this));
        this.propertyAccessors.put(Session.class, new SessionAccessor(this));
        this.propertyAccessors.put(Rule.class, new RuleAccessor(this));
        this.propertyAccessors.put(Goal.class, new GoalAccessor(this));
        this.propertyAccessors.put(CustomItem.class, new CustomItemAccessor(this));
        this.propertyAccessors.put(Campaign.class, new CampaignAccessor(this));
        this.propertyAccessors.put(Map.class, new MapAccessor(this));
    }

    protected NextTokens getNextTokens(String expression) {
        if (expression.startsWith("[\"")) {
            int lookupNameBeginPos = "[\"".length();
            int lookupNameEndPos = expression.indexOf("\"]", lookupNameBeginPos);
            return this.buildNextTokens(expression, lookupNameBeginPos, lookupNameEndPos, lookupNameEndPos + 2);
        }
        if (expression.startsWith(".")) {
            int lookupNameBeginPos = ".".length();
            int lookupNameEndPos = this.findNextStartDelimiterPos(expression, lookupNameBeginPos);
            return this.buildNextTokens(expression, lookupNameBeginPos, lookupNameEndPos, lookupNameEndPos);
        }
        int lookupNameBeginPos = 0;
        int lookupNameEndPos = this.findNextStartDelimiterPos(expression, lookupNameBeginPos);
        return this.buildNextTokens(expression, lookupNameBeginPos, lookupNameEndPos, lookupNameEndPos);
    }

    private NextTokens buildNextTokens(String expression, int lookupNameBeginPos, int lookupNameEndPos, int leftoverStartPos) {
        NextTokens nextTokens = new NextTokens();
        if (lookupNameEndPos >= lookupNameBeginPos) {
            nextTokens.propertyName = expression.substring(lookupNameBeginPos, lookupNameEndPos);
            nextTokens.leftoverExpression = expression.substring(leftoverStartPos);
            if ("".equals(nextTokens.leftoverExpression)) {
                nextTokens.leftoverExpression = null;
            }
        } else {
            nextTokens.propertyName = expression.substring(lookupNameBeginPos);
            nextTokens.leftoverExpression = null;
        }
        return nextTokens;
    }

    private int findNextStartDelimiterPos(String expression, int lookupNameBeginPos) {
        int dotlookupNameEndPos = expression.indexOf(".", lookupNameBeginPos);
        int squareBracketlookupNameEndPos = expression.indexOf("[\"", lookupNameBeginPos);
        int lookupNameEndPos = dotlookupNameEndPos >= lookupNameBeginPos && squareBracketlookupNameEndPos >= lookupNameBeginPos ? Math.min(dotlookupNameEndPos, squareBracketlookupNameEndPos) : (dotlookupNameEndPos >= lookupNameBeginPos ? dotlookupNameEndPos : (squareBracketlookupNameEndPos >= lookupNameBeginPos ? squareBracketlookupNameEndPos : -1));
        return lookupNameEndPos;
    }

    public Object getProperty(Object object, String expression) {
        if (expression == null) {
            return object;
        }
        if (expression.trim().equals("")) {
            return object;
        }
        NextTokens nextTokens = this.getNextTokens(expression);
        ArrayList lookupClasses = new ArrayList();
        lookupClasses.add(object.getClass());
        List<Class<?>> objectClassAncestors = this.cachedClassAncestors.get(object.getClass());
        if (objectClassAncestors == null) {
            objectClassAncestors = this.collectAncestors(object.getClass(), this.propertyAccessors.keySet());
            this.cachedClassAncestors.put(object.getClass(), objectClassAncestors);
        }
        if (objectClassAncestors != null) {
            lookupClasses.addAll(objectClassAncestors);
        }
        for (Class clazz : lookupClasses) {
            Object result;
            HardcodedPropertyAccessor propertyAccessor = this.propertyAccessors.get(clazz);
            if (propertyAccessor == null || "$$$###PROPERTY_NOT_FOUND###$$$".equals(result = propertyAccessor.getProperty(object, nextTokens.propertyName, nextTokens.leftoverExpression))) continue;
            return result;
        }
        return "$$$###PROPERTY_NOT_FOUND###$$$";
    }

    public List<Class<?>> collectAncestors(Class<?> targetClass, Set<Class<?>> availableAccessors) {
        LinkedHashSet parentClasses = new LinkedHashSet();
        if (targetClass.getSuperclass() != null) {
            parentClasses.add(targetClass.getSuperclass());
        }
        if (targetClass.getInterfaces().length > 0) {
            parentClasses.addAll(Arrays.asList(targetClass.getInterfaces()));
        }
        LinkedHashSet ancestors = new LinkedHashSet();
        for (Class clazz : parentClasses) {
            ancestors.addAll(this.collectAncestors(clazz, availableAccessors));
        }
        LinkedHashSet result = new LinkedHashSet();
        result.addAll(parentClasses);
        result.addAll(ancestors);
        return result.stream().filter(availableAccessors::contains).collect(Collectors.toList());
    }

    public static class NextTokens {
        public String propertyName;
        public String leftoverExpression;
    }
}

