/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.EventObject;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.StatefulService;
import org.apache.camel.spi.EventFactory;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ManagementStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventHelper {
    private static final Logger LOG = LoggerFactory.getLogger(EventHelper.class);

    private EventHelper() {
    }

    public static boolean notifyCamelContextStarting(CamelContext context) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        EventObject event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = factory.createCamelContextStartingEvent(context)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyCamelContextStarted(CamelContext context) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        EventObject event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = factory.createCamelContextStartedEvent(context)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyCamelContextStartupFailed(CamelContext context, Throwable cause) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        EventObject event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = factory.createCamelContextStartupFailureEvent(context, cause)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyCamelContextStopping(CamelContext context) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        EventObject event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = factory.createCamelContextStoppingEvent(context)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyCamelContextStopped(CamelContext context) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        EventObject event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = factory.createCamelContextStoppedEvent(context)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyCamelContextStopFailed(CamelContext context, Throwable cause) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        EventObject event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = factory.createCamelContextStopFailureEvent(context, cause)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyServiceStopFailure(CamelContext context, Object service, Throwable cause) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        EventObject event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreServiceEvents()) continue;
            if (event == null && (event = factory.createServiceStopFailureEvent(context, service, cause)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyServiceStartupFailure(CamelContext context, Object service, Throwable cause) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        EventObject event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreServiceEvents()) continue;
            if (event == null && (event = factory.createServiceStartupFailureEvent(context, service, cause)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyRouteStarted(CamelContext context, Route route) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        EventObject event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreRouteEvents()) continue;
            if (event == null && (event = factory.createRouteStartedEvent(route)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyRouteStopped(CamelContext context, Route route) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        EventObject event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreRouteEvents()) continue;
            if (event == null && (event = factory.createRouteStoppedEvent(route)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyRouteAdded(CamelContext context, Route route) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        EventObject event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreRouteEvents()) continue;
            if (event == null && (event = factory.createRouteAddedEvent(route)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyRouteRemoved(CamelContext context, Route route) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        EventObject event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreRouteEvents()) continue;
            if (event == null && (event = factory.createRouteRemovedEvent(route)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyExchangeCreated(CamelContext context, Exchange exchange) {
        if (exchange.getProperty("CamelNotifyEvent", false, Boolean.class).booleanValue()) {
            return false;
        }
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        EventObject event = null;
        for (int i = 0; i < notifiers.size(); ++i) {
            EventNotifier notifier = notifiers.get(i);
            if (notifier.isDisabled() || notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeCreatedEvent()) continue;
            if (event == null && (event = factory.createExchangeCreatedEvent(exchange)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyExchangeDone(CamelContext context, Exchange exchange) {
        if (exchange.getProperty("CamelNotifyEvent", false, Boolean.class).booleanValue()) {
            return false;
        }
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        EventObject event = null;
        for (int i = 0; i < notifiers.size(); ++i) {
            EventNotifier notifier = notifiers.get(i);
            if (notifier.isDisabled() || notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeCompletedEvent()) continue;
            if (event == null && (event = factory.createExchangeCompletedEvent(exchange)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyExchangeFailed(CamelContext context, Exchange exchange) {
        if (exchange.getProperty("CamelNotifyEvent", false, Boolean.class).booleanValue()) {
            return false;
        }
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        EventObject event = null;
        for (int i = 0; i < notifiers.size(); ++i) {
            EventNotifier notifier = notifiers.get(i);
            if (notifier.isDisabled() || notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeFailedEvents()) continue;
            if (event == null && (event = factory.createExchangeFailedEvent(exchange)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyExchangeFailureHandling(CamelContext context, Exchange exchange, Processor failureHandler, boolean deadLetterChannel, String deadLetterUri) {
        if (exchange.getProperty("CamelNotifyEvent", false, Boolean.class).booleanValue()) {
            return false;
        }
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        EventObject event = null;
        for (int i = 0; i < notifiers.size(); ++i) {
            EventNotifier notifier = notifiers.get(i);
            if (notifier.isDisabled() || notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeFailedEvents()) continue;
            if (event == null && (event = factory.createExchangeFailureHandlingEvent(exchange, failureHandler, deadLetterChannel, deadLetterUri)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyExchangeFailureHandled(CamelContext context, Exchange exchange, Processor failureHandler, boolean deadLetterChannel, String deadLetterUri) {
        if (exchange.getProperty("CamelNotifyEvent", false, Boolean.class).booleanValue()) {
            return false;
        }
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        EventObject event = null;
        for (int i = 0; i < notifiers.size(); ++i) {
            EventNotifier notifier = notifiers.get(i);
            if (notifier.isDisabled() || notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeFailedEvents()) continue;
            if (event == null && (event = factory.createExchangeFailureHandledEvent(exchange, failureHandler, deadLetterChannel, deadLetterUri)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyExchangeRedelivery(CamelContext context, Exchange exchange, int attempt) {
        if (exchange.getProperty("CamelNotifyEvent", false, Boolean.class).booleanValue()) {
            return false;
        }
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        EventObject event = null;
        for (int i = 0; i < notifiers.size(); ++i) {
            EventNotifier notifier = notifiers.get(i);
            if (notifier.isDisabled() || notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeFailedEvents()) continue;
            if (event == null && (event = factory.createExchangeRedeliveryEvent(exchange, attempt)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyExchangeSending(CamelContext context, Exchange exchange, Endpoint endpoint) {
        if (exchange.getProperty("CamelNotifyEvent", false, Boolean.class).booleanValue()) {
            return false;
        }
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        EventObject event = null;
        for (int i = 0; i < notifiers.size(); ++i) {
            EventNotifier notifier = notifiers.get(i);
            if (notifier.isDisabled() || notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeSendingEvents()) continue;
            if (event == null && (event = factory.createExchangeSendingEvent(exchange, endpoint)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyExchangeSent(CamelContext context, Exchange exchange, Endpoint endpoint, long timeTaken) {
        if (exchange.getProperty("CamelNotifyEvent", false, Boolean.class).booleanValue()) {
            return false;
        }
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        EventObject event = null;
        for (int i = 0; i < notifiers.size(); ++i) {
            EventNotifier notifier = notifiers.get(i);
            if (notifier.isDisabled() || notifier.isIgnoreExchangeEvents() || notifier.isIgnoreExchangeSentEvents()) continue;
            if (event == null && (event = factory.createExchangeSentEvent(exchange, endpoint, timeTaken)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyCamelContextSuspending(CamelContext context) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        EventObject event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = factory.createCamelContextSuspendingEvent(context)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyCamelContextSuspended(CamelContext context) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        EventObject event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = factory.createCamelContextSuspendedEvent(context)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyCamelContextResuming(CamelContext context) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        EventObject event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = factory.createCamelContextResumingEvent(context)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyCamelContextResumed(CamelContext context) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        EventObject event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = factory.createCamelContextResumedEvent(context)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    public static boolean notifyCamelContextResumeFailed(CamelContext context, Throwable cause) {
        ManagementStrategy management = context.getManagementStrategy();
        if (management == null) {
            return false;
        }
        EventFactory factory = management.getEventFactory();
        if (factory == null) {
            return false;
        }
        List<EventNotifier> notifiers = management.getEventNotifiers();
        if (notifiers == null || notifiers.isEmpty()) {
            return false;
        }
        boolean answer = false;
        EventObject event = null;
        for (EventNotifier notifier : notifiers) {
            if (notifier.isDisabled() || notifier.isIgnoreCamelContextEvents()) continue;
            if (event == null && (event = factory.createCamelContextResumeFailureEvent(context, cause)) == null) {
                return false;
            }
            answer |= EventHelper.doNotifyEvent(notifier, event);
        }
        return answer;
    }

    private static boolean doNotifyEvent(EventNotifier notifier, EventObject event) {
        boolean started = true;
        if (notifier instanceof StatefulService) {
            started = ((StatefulService)((Object)notifier)).isStarted();
        }
        if (!started) {
            LOG.debug("Ignoring notifying event {}. The EventNotifier has not been started yet: {}", (Object)event, (Object)notifier);
            return false;
        }
        if (!notifier.isEnabled(event)) {
            LOG.trace("Notifier: {} is not enabled for the event: {}", (Object)notifier, (Object)event);
            return false;
        }
        try {
            notifier.notify(event);
        }
        catch (Throwable e) {
            LOG.warn("Error notifying event " + event + ". This exception will be ignored. ", e);
        }
        return true;
    }
}

