/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.security.RefreshPolicy;
import org.elasticsearch.client.security.user.privileges.ApplicationPrivilege;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public final class PutPrivilegesRequest
implements Validatable,
ToXContentObject {
    private final Map<String, List<ApplicationPrivilege>> privileges;
    private final RefreshPolicy refreshPolicy;

    public PutPrivilegesRequest(List<ApplicationPrivilege> privileges, @Nullable RefreshPolicy refreshPolicy) {
        if (privileges == null || privileges.isEmpty()) {
            throw new IllegalArgumentException("privileges are required");
        }
        this.privileges = Collections.unmodifiableMap(privileges.stream().collect(Collectors.groupingBy(ApplicationPrivilege::getApplication, TreeMap::new, Collectors.toList())));
        this.refreshPolicy = refreshPolicy == null ? RefreshPolicy.IMMEDIATE : refreshPolicy;
    }

    public Map<String, List<ApplicationPrivilege>> getPrivileges() {
        return this.privileges;
    }

    public RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.privileges, this.refreshPolicy});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutPrivilegesRequest that = (PutPrivilegesRequest)o;
        return this.privileges.equals(that.privileges) && this.refreshPolicy == that.refreshPolicy;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (Map.Entry<String, List<ApplicationPrivilege>> entry : this.privileges.entrySet()) {
            builder.field(entry.getKey());
            builder.startObject();
            for (ApplicationPrivilege applicationPrivilege : entry.getValue()) {
                builder.field(applicationPrivilege.getName());
                applicationPrivilege.toXContent(builder, params);
            }
            builder.endObject();
        }
        return builder.endObject();
    }
}

