/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.InnerRetriever;
import co.elastic.clients.elasticsearch._types.Retriever;
import co.elastic.clients.elasticsearch._types.RetrieverBase;
import co.elastic.clients.elasticsearch._types.RetrieverVariant;
import co.elastic.clients.elasticsearch._types.ScoreNormalizer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class LinearRetriever
extends RetrieverBase
implements RetrieverVariant {
    private final List<InnerRetriever> retrievers;
    @Nullable
    private final Integer rankWindowSize;
    @Nullable
    private final String query;
    private final List<String> fields;
    @Nullable
    private final ScoreNormalizer normalizer;
    public static final JsonpDeserializer<LinearRetriever> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LinearRetriever::setupLinearRetrieverDeserializer);

    private LinearRetriever(Builder builder) {
        super(builder);
        this.retrievers = ApiTypeHelper.unmodifiable(builder.retrievers);
        this.rankWindowSize = builder.rankWindowSize;
        this.query = builder.query;
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.normalizer = builder.normalizer;
    }

    public static LinearRetriever of(Function<Builder, ObjectBuilder<LinearRetriever>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Retriever.Kind _retrieverKind() {
        return Retriever.Kind.Linear;
    }

    public final List<InnerRetriever> retrievers() {
        return this.retrievers;
    }

    @Nullable
    public final Integer rankWindowSize() {
        return this.rankWindowSize;
    }

    @Nullable
    public final String query() {
        return this.query;
    }

    public final List<String> fields() {
        return this.fields;
    }

    @Nullable
    public final ScoreNormalizer normalizer() {
        return this.normalizer;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.retrievers)) {
            generator.writeKey("retrievers");
            generator.writeStartArray();
            for (InnerRetriever innerRetriever : this.retrievers) {
                innerRetriever.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.rankWindowSize != null) {
            generator.writeKey("rank_window_size");
            generator.write(this.rankWindowSize.intValue());
        }
        if (this.query != null) {
            generator.writeKey("query");
            generator.write(this.query);
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (String string : this.fields) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.normalizer != null) {
            generator.writeKey("normalizer");
            this.normalizer.serialize(generator, mapper);
        }
    }

    protected static void setupLinearRetrieverDeserializer(ObjectDeserializer<Builder> op) {
        RetrieverBase.setupRetrieverBaseDeserializer(op);
        op.add(Builder::retrievers, JsonpDeserializer.arrayDeserializer(InnerRetriever._DESERIALIZER), "retrievers");
        op.add(Builder::rankWindowSize, JsonpDeserializer.integerDeserializer(), "rank_window_size");
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query");
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer((JsonpDeserializer)JsonpDeserializer.stringDeserializer()), "fields");
        op.add(Builder::normalizer, ScoreNormalizer._DESERIALIZER, "normalizer");
    }

    public static class Builder
    extends RetrieverBase.AbstractBuilder<Builder>
    implements ObjectBuilder<LinearRetriever> {
        @Nullable
        private List<InnerRetriever> retrievers;
        @Nullable
        private Integer rankWindowSize;
        @Nullable
        private String query;
        @Nullable
        private List<String> fields;
        @Nullable
        private ScoreNormalizer normalizer;

        public final Builder retrievers(List<InnerRetriever> list) {
            this.retrievers = Builder._listAddAll(this.retrievers, list);
            return this;
        }

        public final Builder retrievers(InnerRetriever value, InnerRetriever ... values) {
            this.retrievers = Builder._listAdd(this.retrievers, value, values);
            return this;
        }

        public final Builder retrievers(Function<InnerRetriever.Builder, ObjectBuilder<InnerRetriever>> fn) {
            return this.retrievers(fn.apply(new InnerRetriever.Builder()).build(), new InnerRetriever[0]);
        }

        public final Builder rankWindowSize(@Nullable Integer value) {
            this.rankWindowSize = value;
            return this;
        }

        public final Builder query(@Nullable String value) {
            this.query = value;
            return this;
        }

        public final Builder fields(List<String> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        public final Builder fields(String value, String ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        public final Builder normalizer(@Nullable ScoreNormalizer value) {
            this.normalizer = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public LinearRetriever build() {
            this._checkSingleUse();
            return new LinearRetriever(this);
        }
    }
}

