/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.wsdl20.extensions.http;

import java.net.URI;
import org.apache.woden.ErrorReporter;
import org.apache.woden.wsdl20.Binding;
import org.apache.woden.wsdl20.BindingOperation;
import org.apache.woden.wsdl20.InterfaceOperation;
import org.apache.woden.wsdl20.WSDLComponent;
import org.apache.woden.wsdl20.extensions.BaseComponentExtensionContext;
import org.apache.woden.wsdl20.extensions.ExtensionProperty;
import org.apache.woden.wsdl20.extensions.InterfaceOperationExtensions;
import org.apache.woden.wsdl20.extensions.WSDLExtensionConstants;
import org.apache.woden.wsdl20.extensions.http.HTTPBindingExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPBindingOperationExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPConstants;
import org.apache.woden.wsdl20.extensions.http.HTTPLocation;
import org.apache.woden.wsdl20.xml.WSDLElement;
import org.apache.woden.xml.BooleanAttr;
import org.apache.woden.xml.StringAttr;

public class HTTPBindingOperationExtensionsImpl
extends BaseComponentExtensionContext
implements HTTPBindingOperationExtensions {
    public HTTPBindingOperationExtensionsImpl(WSDLComponent parent, URI extNamespace, ErrorReporter errReporter) {
        super(parent, extNamespace, errReporter);
    }

    public ExtensionProperty[] getProperties() {
        return new ExtensionProperty[]{this.getProperty("http location"), this.getProperty("http location ignore uncited"), this.getProperty("http method"), this.getProperty("http input serialization"), this.getProperty("http output serialization"), this.getProperty("http fault serialization"), this.getProperty("http query parameter separator"), this.getProperty("http content encoding default")};
    }

    public ExtensionProperty getProperty(String propertyName) {
        if ("http location".equals(propertyName)) {
            return this.newExtensionProperty("http location", this.getHttpLocation());
        }
        if ("http location ignore uncited".equals(propertyName)) {
            return this.newExtensionProperty("http location ignore uncited", this.isHttpLocationIgnoreUncited());
        }
        if ("http method".equals(propertyName)) {
            return this.newExtensionProperty("http method", this.getHttpMethod());
        }
        if ("http input serialization".equals(propertyName)) {
            return this.newExtensionProperty("http input serialization", this.getHttpInputSerialization());
        }
        if ("http output serialization".equals(propertyName)) {
            return this.newExtensionProperty("http output serialization", this.getHttpOutputSerialization());
        }
        if ("http fault serialization".equals(propertyName)) {
            return this.newExtensionProperty("http fault serialization", this.getHttpFaultSerialization());
        }
        if ("http query parameter separator".equals(propertyName)) {
            return this.newExtensionProperty("http query parameter separator", this.getHttpQueryParameterSeparator());
        }
        if ("http content encoding default".equals(propertyName)) {
            return this.newExtensionProperty("http content encoding default", this.getHttpContentEncodingDefault());
        }
        return null;
    }

    public HTTPLocation getHttpLocation() {
        StringAttr httpLoc = (StringAttr)((WSDLElement)((Object)this.getParent())).getExtensionAttribute(HTTPConstants.Q_ATTR_LOCATION);
        return httpLoc != null ? new HTTPLocation(httpLoc.getString()) : null;
    }

    public Boolean isHttpLocationIgnoreUncited() {
        BooleanAttr ignoreUncited = (BooleanAttr)((WSDLElement)((Object)this.getParent())).getExtensionAttribute(HTTPConstants.Q_ATTR_IGNORE_UNCITED);
        return ignoreUncited != null ? ignoreUncited.getBoolean() : new Boolean(false);
    }

    public String getHttpMethod() {
        StringAttr methodAttr = (StringAttr)((WSDLElement)((Object)this.getParent())).getExtensionAttribute(HTTPConstants.Q_ATTR_METHOD);
        if (methodAttr != null) {
            return methodAttr.getString();
        }
        return null;
    }

    public String getHttpInputSerialization() {
        StringAttr serialization = (StringAttr)((WSDLElement)((Object)this.getParent())).getExtensionAttribute(HTTPConstants.Q_ATTR_INPUT_SERIALIZATION);
        if (serialization != null) {
            return serialization.getString();
        }
        String method = this.determineHttpMethod();
        if (method.equals("GET") || method.equals("DELETE")) {
            return "application/x-www-form-urlencoded";
        }
        return "application/xml";
    }

    public String getHttpOutputSerialization() {
        StringAttr serialization = (StringAttr)((WSDLElement)((Object)this.getParent())).getExtensionAttribute(HTTPConstants.Q_ATTR_OUTPUT_SERIALIZATION);
        return serialization != null ? serialization.getString() : "application/xml";
    }

    public String getHttpFaultSerialization() {
        StringAttr serialization = (StringAttr)((WSDLElement)((Object)this.getParent())).getExtensionAttribute(HTTPConstants.Q_ATTR_FAULT_SERIALIZATION);
        return serialization != null ? serialization.getString() : "application/xml";
    }

    public String getHttpQueryParameterSeparator() {
        StringAttr separator = (StringAttr)((WSDLElement)((Object)this.getParent())).getExtensionAttribute(HTTPConstants.Q_ATTR_QUERY_PARAMETER_SEPARATOR);
        return separator != null ? separator.getString() : null;
    }

    public String getHttpContentEncodingDefault() {
        StringAttr contEncodingDef = (StringAttr)((WSDLElement)((Object)this.getParent())).getExtensionAttribute(HTTPConstants.Q_ATTR_CONTENT_ENCODING_DEFAULT);
        return contEncodingDef != null ? contEncodingDef.getString() : null;
    }

    private String determineHttpMethod() {
        InterfaceOperationExtensions intOperExts;
        String method = this.getHttpMethod();
        if (method != null) {
            return method;
        }
        Binding binding = (Binding)((BindingOperation)this.getParent()).getParent();
        HTTPBindingExtensions httpBindExts = (HTTPBindingExtensions)binding.getComponentExtensionContext(HTTPConstants.NS_URI_HTTP);
        String methodDef = httpBindExts.getHttpMethodDefault();
        if (methodDef != null) {
            return methodDef;
        }
        InterfaceOperation intOper = ((BindingOperation)this.getParent()).getInterfaceOperation();
        if (intOper != null && (intOperExts = (InterfaceOperationExtensions)intOper.getComponentExtensionContext(WSDLExtensionConstants.NS_URI_WSDL_EXTENSIONS)) != null && intOperExts.isSafe()) {
            return "GET";
        }
        return "POST";
    }
}

